@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE EGRESOS REGISTRADOS</h4>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Local</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Concepto</th>
                        <th class="head_table">Monto S/</th>
                        <th class="head_table">Fecha de registro</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $row)
                    <tr data-table="{{ $row->id_egreso}}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->local->nombre }} {{ $row->local->descripcion }}</td>
                        <td>{{ $row->tipo_egreso }}</td>
                        <td>{{ $row->concepto}}</td>
                        <td>{{ $row->monto }}</td>
                        <td>{{ $row->created_at }}</td>
                        <td>                            
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('egreso/detalles/'.$row->id_egreso) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


