$(function () {
    
    $('.btn_enviar').on('click', function() {
        $('#email_modal').modal('show'); 
    }); 

    $('.btn_whatsapp').on('click', function() {
        $('#whatsapp_modal').modal('show'); 
    }); 

    $('#frmEmail').form({
        fields: {
          email_cliente: {
              rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'email', prompt : 'Ingrese un email valido'}
                ]
          },
        },
    });

    $('#frmNumero').form({
        fields: {
          numero_cliente: {
              rules: [
                    { type : 'empty', prompt : 'Complete este campo'},
                    { type : 'integer', prompt : 'Ingrese un numero valido'},
                    { type : 'exactLength[9]', prompt : 'Debe tener {ruleValue} digitos'}
                ]
          },
        },
    });
	
  	$('.btn_enviar_correo').on('click', function() {

  		var id = $(this).data("id");
  		var email = $('#email_cliente').val();

        if ($('#frmEmail').form('is valid')) {
            $('.ui.error.message').css('visibility', 'hidden');
            $('#email_modal').modal('hide'); 
            swal({title: "Correcto!", text: "El comprobante fue enviado al email del cliente", icon: "success", button: "OK"});
            window.open(APP_URL+'/../pdf/enviaCorreo.php?id_venta='+id+'&email_cliente='+email ,'_blank');
        } else {
            $('#frmEmail').form('validate form');
            $('.ui.error.message').css('visibility', 'visible');
            $('#email_cliente').val('');
        }
  	});	



    $('.btn_enviar_correo_nota').on('click', function() {

      var id = $(this).data("id");
      var email = $('#email_cliente').val();

        if ($('#frmEmail').form('is valid')) {
            $('.ui.error.message').css('visibility', 'hidden');
            $('#email_modal').modal('hide'); 
            swal({title: "Correcto!", text: "El comprobante fue enviado al email del cliente", icon: "success", button: "OK"});
            window.open(APP_URL+'/../pdf/enviaCorreoNota.php?id_nota='+id+'&email_cliente='+email ,'_blank');
        } else {
            $('#frmEmail').form('validate form');
            $('.ui.error.message').css('visibility', 'visible');
            $('#email_cliente').val('');
        }
    }); 



    $('.btn_enviar_whatsapp').on('click', function() {

        var id = $(this).data("id");
        var numero = $('#numero_cliente').val();

        if ($('#frmNumero').form('is valid')) {
            $('.ui.error.message').css('visibility', 'hidden');
            $('#whatsapp_modal').modal('hide'); 
            swal({title: "Correcto!", text: "Complete el proceso en Whatsapp Web", icon: "success", button: "OK"});
            //window.open(''+APP_URL+'/../pdf/enviaCorreo.php?id_venta='+id+'&numero_cliente='+email ,'_blank');
            window.open('https://api.whatsapp.com/send?phone=+51'+numero+'&text='+APP_URL+'/../pdf/imprimeA4.php?id_venta='+id,'_blank');
        } else {
            $('#frmNumero').form('validate form');
            $('.ui.error.message').css('visibility', 'visible');
            $('#numero_cliente').val('');
        }
    }); 

    $('.btn_enviar_whatsapp_nota').on('click', function() {

        var id = $(this).data("id");
        var numero = $('#numero_cliente').val();

        if ($('#frmNumero').form('is valid')) {
            $('.ui.error.message').css('visibility', 'hidden');
            $('#whatsapp_modal').modal('hide'); 
            swal({title: "Correcto!", text: "Complete el proceso en Whatsapp Web", icon: "success", button: "OK"});
            //window.open(''+APP_URL+'/../pdf/enviaCorreo.php?id_venta='+id+'&numero_cliente='+email ,'_blank');
            window.open('https://api.whatsapp.com/send?phone=+51'+numero+'&text='+APP_URL+'/../pdf/imprimeNotaA4.php?id_nota='+id,'_blank');
        } else {
            $('#frmNumero').form('validate form');
            $('.ui.error.message').css('visibility', 'visible');
            $('#numero_cliente').val('');
        }
    }); 


    $('.btn_imprimir').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeTicket.php?id_venta='+id, '_blank');
    }); 

    $('.btn_imprimir_a4').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeA4.php?id_venta='+id, '_blank');
    }); 

    $('.btn_imprimir_nota_a4').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeNotaA4.php?id_nota='+id, '_blank');
    });

});



