<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVentasCreditoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ventas_credito', function (Blueprint $table) {
            $table->integer('id_ventas_credito')->autoIncrement();
            $table->integer('id_venta');
            $table->string('nombre_cuota', 20)->nullable();
            $table->integer('numero_cuota')->nullable();
            $table->decimal('monto_cuota', 9, 2)->nullable(); 
            $table->date('fecha_pago_cuota')->nullable(); 
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            $table->foreign('id_venta')
                  ->references('id_venta')->on('ventas')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');
   
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ventas_credito');
    }
}
