<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleTraslado extends Model
{
    protected $table = 'detalle_traslado';
    protected $primaryKey = 'id_detalle_traslado';

    protected $fillable = [
        'id_detalle_traslado', 'id_traslado','id_producto', 'cantidad', 'estado'
    ];

    public function traslado()
    {
        return $this->belongsTo('App\Models\Traslado', 'id_traslado');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}