<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Models\Venta;
use App\Models\DetalleVenta;
use App\Models\Proforma;
use App\Models\DetalleProforma;
use App\Models\ProductoLocal;
use App\Models\Local;
use App\Models\TipoPresentacion;
use App\Models\UnidadMedida;
use App\Models\Cliente;
use App\Models\Producto;
use App\Models\Usuario;
use App\Models\DetalleCredito;
use App\Models\TipoComprobante;
use App\Models\TipoDocumento;
use App\Models\Empresa;
use App\Http\Controllers\XmlController;


class ProformaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar()
    {
        $res = Proforma::with(['local', 'usuario'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('proforma.listar', [ 'data' => $res]); 
    }

    public function nuevo()
    {

        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'empresa' => Empresa::where('estado', 1)->first(), 
            'productos' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(50)->get(),
            'producto' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(50)->get(),

            'tipo_presentacion' => TipoPresentacion::all(), 
            'unidad_medida' => UnidadMedida::all(), 
            'clientes' => Cliente::where('estado', 1)->orderBy('nombre', 'ASC')->limit(20)->get(), 

        ];
        return view('proforma.nuevo', $data); 
    }

    public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => $id_local]);
            $request->request->add(['total' => $request->total_venta]);
            $res = Proforma::create($request->all());

            if (!is_null($res->adelanto)) {
                $pro = Proforma::find($res->id_proforma);
                $pro->saldo = $res->total - $res->adelanto;
                $pro->save();
            }

            if (!is_null($request->nombre) && !is_null($request->numero_documento) && (Cliente::where('numero_documento', $request->numero_documento)->count() == 0)) {
                if (strlen($request->numero_documento) == 11) {
                    $id_tipo_documento = 1;
                } else{
                    $id_tipo_documento = 2;
                }
                $cliente= [
                    'id_tipo_documento' => $id_tipo_documento, 
                    'nombre' => $request->nombre, 
                    'numero_documento' => $request->numero_documento, 
                    'direccion' => $request->direccion, 
                ];

                Cliente::create($cliente);
            }
            
            if ($res) 
            {
                for( $i = 0; $i < count($request->id_producto); $i++)
                {
                    $detalle= [
                        'id_proforma' => $res->id_proforma, 
                        'id_producto' => $request->id_producto[$i], 
                        'cantidad' => $request->cantidad[$i], 
                        'precio' => $request->precio_venta[$i], 
                        'descuento' => $request->descuento[$i], 
                        'subtotal' => $request->subtotal[$i], 
                    ];

                    $res1 = DetalleProforma::create($detalle);

                    if ($res1) 
                    {
                        $produ = Producto::find($request->id_producto[$i]);
                        if (is_null($produ->precio_compra)) {
                            $produ->precio_compra = 0;
                        }
                        //$produ->precio = $request->precio_venta[$i];
                        $produ->utilidad= (($request->precio_venta[$i] - $produ->precio_compra) < 0 ) ? 0 : ($request->precio_venta[$i] - $produ->precio_compra);
                        $produ->save();
                    }

                    if ($request->tipo == "PEDIDO") 
                    {
                        $producto_local = ProductoLocal::where(['id_producto' => $request->id_producto[$i] , 'id_local' => $id_local, 'estado' => 1])->get();
                        $prod = ProductoLocal::find($producto_local[0]->id_producto_local);
                        $prod->stock = ($producto_local[0]->stock - $request->cantidad[$i]) < 1000000 ? 1000000 : ($producto_local[0]->stock - $request->cantidad[$i]);
                        $prod->save();
                    }
                }  
            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 

        }
    }

    public function detalles($id)
    {
        return view('proforma.detalles', [
            'data' => Proforma::with(['local', 'usuario'])->where(['id_proforma' => $id, 'estado' => 1])->first(),
            'detalle_proforma' => DetalleProforma::with(['producto'])->where(['id_proforma' => $id, 'estado' => 1])->orderBy('id_detalle_proforma', 'ASC')->get(),
            'productos' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(20)->get(),

            'empresa' => Empresa::where('estado', 1)->first(), 
            'tipo_presentacion' => TipoPresentacion::all(), 
            'unidad_medida' => UnidadMedida::all(), 
            'producto' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(20)->get(),
        ]); 
    }


    public function agregar_item(Request $request)
    {
        if ($request->ajax())
        {
            
            for( $i = 0; $i < count($request->id_producto); $i++)
            {
                $producto = DetalleProforma::where('id_proforma', $request->id_proforma)->where('id_producto', $request->id_producto[$i])->get();
                
                if ($producto->count() == 0) {
                    
                    $detalle= [
                        'id_proforma' => $request->id_proforma, 
                        'id_producto' => $request->id_producto[$i], 
                        'cantidad' => $request->cantidad[$i], 
                        'precio' => $request->precio_venta[$i], 
                        'descuento' => $request->descuento[$i], 
                        'subtotal' => $request->subtotal[$i], 
                    ];

                    DetalleProforma::create($detalle);
                }
                else {
                    $prod = DetalleProforma::find($producto[0]->id_detalle_proforma);

                    $prod->cantidad = $prod->cantidad + $request->cantidad[$i];
                    $prod->descuento = $prod->descuento + $request->descuento[$i];
                    $prod->subtotal = $prod->subtotal + $request->subtotal[$i];

                    $prod->save();     
                }
            }

            $data = Proforma::find($request->id_proforma);
            $data->saldo = ($data->total + $request->total) - $data->adelanto;
            $data->total = $data->total + $request->total;
            $data->save();

            $res['message'] = 'success';

            return response()->json($res); 
        }
    }

    public function quitar_item(Request $request)
    {
        if ($request->ajax())
        {
            $data = DetalleProforma::find($request->id_detalle_proforma);

            $data2 = Proforma::find($request->id_proforma);
            $data2->saldo = ($data2->total - $data->subtotal) - $data2->adelanto;
            $data2->total = $data2->total - $data->subtotal;
            $data2->save();


            DetalleProforma::where('id_detalle_proforma', $data->id_detalle_proforma)->delete();

            $res['message'] = 'success' ;

            return response()->json($res); 
        }
    }

    public function anular(Request $request)
    {
        if ($request->ajax())
        {
            $data = Proforma::find($request->id_proforma);
            $data->id_usuario = Auth::guard("usuario")->user()->id_usuario; 
            $data->estado = 0; 
            $res = $data->save();

            $detalle = DetalleProforma::where('id_proforma', $request->id_proforma)->get();
            $id_local = Auth::guard("usuario")->user()->id_local;

            foreach ($detalle as $row) {
                $producto_local = ProductoLocal::where(['id_producto' => $row->id_producto , 'id_local' => $id_local, 'estado' => 1])->get();
                $prod = ProductoLocal::find($producto_local[0]->id_producto_local);
                $prod->stock = ($prod->stock + $row->cantidad);
                $prod->save();
            }

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);
        }
    }

     public function buscar(Request $request)
    {
        if ($request)
        {
            $res =  Proforma::with(['local'])->where(function ($query) {
                    $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1);
                })->where(function ($query)  use ($request) {
                    $query->where('id_proforma', '=',  $request->search);
                })->paginate(10);


            if(count($res)==0) {
                $res =  Proforma::with(['local'])->where(function ($query) {
                    $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1);
                })->where(function ($query)  use ($request) {
                    $query->where('total', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('tipo', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('nombre', 'LIKE',  '%'.$request->search.'%')
                          ->orWhere('numero_documento', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('observacion', 'LIKE', '%'.$request->search.'%')
                          ->orWhere('fecha_emision', 'LIKE', '%'.$request->search.'%');
                })->orderBy('created_at', 'desc')->paginate(10);
            } 

            
            $res->appends(['search' => $request->search]); 
            return view('proforma.listar', [ 'data' => $res]); 

        }
    }

    public function getProductosById(Request $request)
    {
        if ($request)
        {
            $prod =  DetalleProforma::with(['producto'])->where(['id_proforma' => $request->id_proforma, 'estado' => 1])->orderBy('id_detalle_proforma', 'ASC')->get();

            $local = Proforma::where(['id_proforma' => $request->id_proforma])->first();

            if ($prod)
            { 
                foreach ($prod as $data) {
                    $res[] = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $data->id_producto)->where('id_local', $local->id_local)->where('stock', '>', 0)->first();
                }
            }
            return response()->json($res); 
        }
    }


    public function listar_deuda()
    {
        $res = Proforma::with(['local', 'usuario'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('tipo', 'PEDIDO')->where('adelanto', '<>', null)->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);

        return view('proforma.listar_deuda', [ 'data' => $res]); 
    }

    public function detalles_deuda($id)
    {
        return view('proforma.detalles_deuda', [
            'data' => Proforma::with(['local', 'usuario'])->where(['id_proforma' => $id])->where('estado', 1)->first(),
            'pagado' => DB::table('detalle_credito')->where(['id_proforma' => $id, 'estado' => 1])->sum('monto'),
            'detalle_credito' => DetalleCredito::with(['usuario'])->where(['id_proforma' => $id, 'estado' => 1])->orderBy('created_at', 'desc')->get(),
        ]); 
    }

    public function anular_deuda(Request $request)
    {
        if ($request->ajax())
        {
            $data = Proforma::find($request->id_proforma);
            
            $datos = [
                'id_usuario' => Auth::guard("usuario")->user()->id_usuario,
                'id_proforma' => $request->id_proforma,
                'fecha_pago' => date('Y-m-d'),
                'monto' => $data->saldo,
                'observacion' => "LIQUIDACION TOTAL DE LA DEUDA",
            ];
            $res = DetalleCredito::create($datos);

            $data->saldo = 0; 
            $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }



    public function registrar_letra(Request $request)
    {
        if ($request->ajax())
        {
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]);
            $request->request->add(['fecha_pago' => date('Y-m-d')]);

            $res = DetalleCredito::create($request->all());

            $data = Proforma::find($request->id_proforma);
            $data->saldo = ($data->saldo - $request->monto) < 0 ?  0 : ($data->saldo - $request->monto); 
            $data->save();

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }

    public function eliminar_letra(Request $request)
    {
        if ($request->ajax())
        {
            $data = DetalleCredito::find($request->id_detalle_credito);
            $data->estado = 0;
            $res  = $data->save();

            $data2 = Proforma::find($data->id_proforma);
            $data2->saldo = $data2->saldo + $data->monto; 
            $data2->save();
        
            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    
    public function buscar_deuda(Request $request)
    {
        if ($request)
        {

            $res =  Proforma::with(['local', 'usuario'])->where(function ($query) {
                        $query->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('tipo', 'PEDIDO')->where('saldo', '>', 0)->where('estado', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('id_proforma', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_emision', 'LIKE', '%'.$request->search.'%');
                    })->paginate(10);

            $res->appends(['search' => $request->search]); 
            return view('proforma.listar_deuda', ['data' => $res]); 
        }
    }



}
